// To parse this JSON data, do
//
//     final invoiceListResponseModel = invoiceListResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:viserpay/data/model/global/charge/charge_model.dart';
import 'package:viserpay/data/model/global/meassage_model.dart';

InvoiceListResponseModel invoiceListResponseModelFromJson(String str) => InvoiceListResponseModel.fromJson(json.decode(str));

String invoiceListResponseModelToJson(InvoiceListResponseModel data) => json.encode(data.toJson());

class InvoiceListResponseModel {
  String? remark;
  String? status;
  Message? message;
  Data? data;

  InvoiceListResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory InvoiceListResponseModel.fromJson(Map<String, dynamic> json) => InvoiceListResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
      };
}

class Data {
  List<String>? otpType;
  String? currentBalance;
  GlobalCharge? paymentCharge;
  Invoices? invoices;

  Data({
    this.otpType,
    this.currentBalance,
    this.paymentCharge,
    this.invoices,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        otpType: json["otp_type"] == null ? [] : List<String>.from(json["otp_type"]!.map((x) => x)),
        currentBalance: json["current_balance"],
        paymentCharge: json["payment_charge"] == null ? null : GlobalCharge.fromJson(json["payment_charge"]),
        invoices: json["invoices"] == null ? null : Invoices.fromJson(json["invoices"]),
      );

  Map<String, dynamic> toJson() => {
        "otp_type": otpType == null ? [] : List<dynamic>.from(otpType!.map((x) => x)),
        "current_balance": currentBalance,
        "payment_charge": paymentCharge?.toJson(),
        "invoices": invoices?.toJson(),
      };
}

class Invoices {
  String? currentPage;
  List<InvoiceDataModel>? data;
  String? firstPageUrl;
  String? from;
  String? lastPage;
  String? lastPageUrl;
  String? nextPageUrl;
  String? path;
  String? perPage;
  String? prevPageUrl;
  String? to;
  String? total;

  Invoices({
    this.currentPage,
    this.data,
    this.firstPageUrl,
    this.from,
    this.lastPage,
    this.lastPageUrl,
    this.nextPageUrl,
    this.path,
    this.perPage,
    this.prevPageUrl,
    this.to,
    this.total,
  });

  factory Invoices.fromJson(Map<String, dynamic> json) => Invoices(
        currentPage: json["current_page"]?.toString(),
        data: json["data"] == null ? [] : List<InvoiceDataModel>.from(json["data"]!.map((x) => InvoiceDataModel.fromJson(x))),
        firstPageUrl: json["first_page_url"]?.toString(),
        from: json["from"]?.toString(),
        lastPage: json["last_page"]?.toString(),
        lastPageUrl: json["last_page_url"]?.toString(),
        nextPageUrl: json["next_page_url"]?.toString(),
        path: json["path"]?.toString(),
        perPage: json["per_page"]?.toString(),
        prevPageUrl: json["prev_page_url"]?.toString(),
        to: json["to"]?.toString(),
        total: json["total"]?.toString(),
      );

  Map<String, dynamic> toJson() => {
        "current_page": currentPage,
        "data": data == null ? [] : List<dynamic>.from(data!.map((x) => x.toJson())),
        "first_page_url": firstPageUrl,
        "from": from,
        "last_page": lastPage,
        "last_page_url": lastPageUrl,
        "next_page_url": nextPageUrl,
        "path": path,
        "per_page": perPage,
        "prev_page_url": prevPageUrl,
        "to": to,
        "total": total,
      };
}

class InvoiceDataModel {
  int? id;
  String? invoiceUid;
  String? userId;
  int? merchantId;
  String? totalAmount;
  String? totalItem;
  String? cancelReason;
  String? status;
  String? createdAt;
  String? updatedAt;
  MerchantOrUserInfoModel? user;
  MerchantOrUserInfoModel? merchant;
  List<InvoiceItem>? invoiceItem;

  InvoiceDataModel({
    this.id,
    this.invoiceUid,
    this.userId,
    this.merchantId,
    this.totalAmount,
    this.totalItem,
    this.cancelReason,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.user,
    this.merchant,
    this.invoiceItem,
  });

  factory InvoiceDataModel.fromJson(Map<String, dynamic> json) => InvoiceDataModel(
        id: json["id"],
        invoiceUid: json["uid"]?.toString(),
        userId: json["user_id"]?.toString(),
        merchantId: json["merchant_id"],
        totalAmount: json["total_amount"]?.toString(),
        totalItem: json["total_item"]?.toString(),
        cancelReason: json["cancel_reason"]?.toString(),
        status: json["status"]?.toString(),
        createdAt: json["created_at"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
        user: json["user"] == null ? null : MerchantOrUserInfoModel.fromJson(json["user"]),
        merchant: json["merchant"] == null ? null : MerchantOrUserInfoModel.fromJson(json["merchant"]),
        invoiceItem: json["invoice_item"] == null ? [] : List<InvoiceItem>.from(json["invoice_item"]!.map((x) => InvoiceItem.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "uid": invoiceUid,
        "user_id": userId,
        "merchant_id": merchantId,
        "total_amount": totalAmount,
        "total_item": totalItem,
        "cancel_reason": cancelReason,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "user": user?.toJson(),
        "merchant": merchant?.toJson(),
        "invoice_item": invoiceItem == null ? [] : List<dynamic>.from(invoiceItem!.map((x) => x.toJson())),
      };
}

class InvoiceItem {
  int? id;
  String? invoiceId;
  String? name;
  String? price;
  String? createdAt;
  String? updatedAt;

  InvoiceItem({
    this.id,
    this.invoiceId,
    this.name,
    this.price,
    this.createdAt,
    this.updatedAt,
  });

  factory InvoiceItem.fromJson(Map<String, dynamic> json) => InvoiceItem(
        id: json["id"],
        invoiceId: json["invoice_id"]?.toString(),
        name: json["name"]?.toString(),
        price: json["price"]?.toString(),
        createdAt: json["created_at"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "invoice_id": invoiceId,
        "name": name,
        "price": price,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class MerchantOrUserInfoModel {
  int? id;
  String? username;
  String? firstName;
  String? lastName;
  String? email;
  String? mobile;
  String? getImage;
  String? dialCode;

  MerchantOrUserInfoModel({
    this.id,
    this.username,
    this.firstName,
    this.lastName,
    this.email,
    this.mobile,
    this.getImage,
    this.dialCode,
  });

  factory MerchantOrUserInfoModel.fromJson(Map<String, dynamic> json) => MerchantOrUserInfoModel(
        id: json["id"],
        username: json["username"]?.toString(),
        firstName: json["firstname"]?.toString(),
        lastName: json["lastname"]?.toString(),
        email: json["email"]?.toString(),
        mobile: json["mobile"]?.toString(),
        getImage: json["get_image"]?.toString(),
        dialCode: json["dial_code"]?.toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "username": username,
        "firstname": firstName,
        "lastname": lastName,
        "email": email,
        "mobile": mobile,
        "get_image": getImage,
        "dial_code": dialCode,
      };

  // Method to get the name or fallback value
  String getDisplayName() {
    if ((firstName ?? '').isNotEmpty || (lastName ?? '').isNotEmpty) {
      return '${firstName ?? ''} ${lastName ?? ''}'.trim();
    }
    if ((username ?? '').isNotEmpty) {
      return username!;
    }
    return mobile ?? '';
  }
}
